/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import net.nooj4nlp.engine.Charlist;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Indexkey;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Mft;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.TransitionObject;
import net.nooj4nlp.engine.TransitionPair;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Ntext
implements Serializable {
    private static final long serialVersionUID = 4556178507526248243L;
    public String LanguageName;
    public transient Language Lan;
    public String DelimPattern;
    public String[] XmlNodes;
    public transient Charlist charlist = null;
    public transient HashMap<String, Indexkey> hTokens = null;
    public transient HashMap<String, ArrayList<Object>> hAmbiguities = null;
    public transient HashMap<String, ArrayList<Object>> hUnambiguities = null;
    public transient HashMap<String, Indexkey> hDigrams = null;
    public transient HashMap<String, Integer> hLexemes = null;
    public transient HashMap<String, Integer> hUnknowns = null;
    public transient HashMap<String, Integer> hPhrases = null;
    public transient ArrayList<String> listOfResources = null;
    public String buffer;
    public Mft mft;
    public ArrayList<Object> annotations;
    public int nbOfTextUnits;
    public int nbOfChars;
    public int nbOfDiffChars;
    public int nbOfLetters;
    public int nbOfDiffLetters;
    public int nbOfDelimiters;
    public int nbOfDiffDelimiters;
    public int nbOfBlanks;
    public int nbOfDiffBlanks;
    public int nbOfDigits;
    public int nbOfDiffDigits;
    public int nbOfTokens;
    public int nbOfDiffTokens;
    public int nbOfWords;
    public int nbOfDiffWords;

    public Ntext(String languageName, String delimPattern, String[] xmlNodes) {
        ParameterCheck.mandatoryString("languageName", languageName);
        this.LanguageName = languageName;
        this.Lan = new Language(languageName);
        if (this.Lan != null) {
            this.DelimPattern = delimPattern;
            this.XmlNodes = xmlNodes;
            this.charlist = null;
            this.buffer = null;
            this.mft = null;
            this.annotations = null;
            this.nbOfDiffWords = -1;
            this.nbOfWords = -1;
            this.nbOfDiffTokens = -1;
            this.nbOfTokens = -1;
            this.nbOfDiffDigits = -1;
            this.nbOfDigits = -1;
            this.nbOfDiffBlanks = -1;
            this.nbOfBlanks = -1;
            this.nbOfDiffDelimiters = -1;
            this.nbOfDelimiters = -1;
            this.nbOfDiffLetters = -1;
            this.nbOfLetters = -1;
            this.nbOfDiffChars = -1;
            this.nbOfChars = -1;
            this.nbOfTextUnits = -1;
        } else {
            System.out.println("Cannot construct language for languagename = " + languageName);
        }
    }

    public Ntext(String languageName) {
        ParameterCheck.mandatoryString("languageName", languageName);
        this.LanguageName = languageName;
        this.Lan = new Language(languageName);
        if (this.Lan != null) {
            this.DelimPattern = null;
            this.XmlNodes = null;
            this.charlist = null;
            this.buffer = null;
            this.mft = null;
            this.annotations = null;
            this.nbOfDiffWords = -1;
            this.nbOfWords = -1;
            this.nbOfDiffTokens = -1;
            this.nbOfTokens = -1;
            this.nbOfDiffDigits = -1;
            this.nbOfDigits = -1;
            this.nbOfDiffBlanks = -1;
            this.nbOfBlanks = -1;
            this.nbOfDiffDelimiters = -1;
            this.nbOfDelimiters = -1;
            this.nbOfDiffLetters = -1;
            this.nbOfLetters = -1;
            this.nbOfDiffChars = -1;
            this.nbOfChars = -1;
            this.nbOfTextUnits = -1;
        }
    }

    public final String delimitTextUnits(Engine engine) {
        ParameterCheck.mandatory("engine", engine);
        this.mft = engine.delimit(this);
        if (this.mft == null) {
            return "Cannot split text into text units: one text unit is larger than 65K characters";
        }
        return "";
    }

    public final void cleanupBadAnnotations(ArrayList<Object> annotations) {
        ArrayList<TransitionObject> transitions;
        int itu;
        ParameterCheck.mandatoryCollection("annotations", annotations);
        HashMap foundANullAnnotation = new HashMap();
        for (int i = 0; i < annotations.size(); ++i) {
            String lexeme = (String)annotations.get(i);
            if (lexeme == null) {
                foundANullAnnotation.put(i, null);
                continue;
            }
            String entry = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            String lemma = null;
            RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
            String category = null;
            RefObject<Object> tempRef_category = new RefObject<Object>(category);
            String features = null;
            RefObject<Object> tempRef_features = new RefObject<Object>(features);
            boolean tempVar = !Dic.parseDELAF(lexeme, tempRef_entry, tempRef_lemma, null, tempRef_category, tempRef_features, null);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            features = (String)tempRef_features.argvalue;
            if (tempVar || !category.equals("NW") && (features == null || features.equals("") || Dic.lookFor("FXC", features, null) == null)) continue;
            annotations.set(i, null);
            foundANullAnnotation.put(i, null);
        }
        if (foundANullAnnotation.size() > 0) {
            for (itu = 1; itu < this.mft.tuAddresses.length; ++itu) {
                transitions = this.mft.aTransitions.get(itu);
                for (int istate = 0; istate < transitions.size(); ++istate) {
                    ArrayList<TransitionPair> state = transitions.get(istate).getOutgoings();
                    int k = 0;
                    while (k < state.size()) {
                        int tokenId = state.get(k).getTokenId();
                        if (foundANullAnnotation.containsKey(tokenId)) {
                            state.subList(k, k + 1).clear();
                            continue;
                        }
                        ++k;
                    }
                }
            }
        }
        for (itu = 1; itu < this.mft.tuAddresses.length; ++itu) {
            int istate;
            transitions = this.mft.aTransitions.get(itu);
            HashMap endings = new HashMap();
            for (istate = 0; istate < transitions.size(); ++istate) {
                ArrayList<TransitionPair> outgoings = transitions.get(istate).getOutgoings();
                for (int k = 0; k < outgoings.size(); ++k) {
                    double ending = outgoings.get(k).getRelEndAddress();
                    if (endings.containsKey(ending)) continue;
                    endings.put(ending, null);
                }
            }
            istate = 0;
            while (istate < transitions.size()) {
                int h_beg2;
                double beginning = transitions.get(istate).getRelBegAddress();
                int h_beg = (int)(100.0 * beginning);
                if (h_beg != (h_beg2 = (int)beginning * 100)) {
                    if (!endings.containsKey(beginning)) {
                        transitions.subList(istate, istate + 1).clear();
                        continue;
                    }
                    ++istate;
                    continue;
                }
                ++istate;
            }
        }
    }

    private void keepOnlyInternal(RefObject<ArrayList<String>> lexs, RefObject<ArrayList<Double>> lens, int length) {
        ParameterCheck.mandatory("lexs", lexs);
        ParameterCheck.mandatory("lens", lens);
        int i = 0;
        while (i < ((ArrayList)lexs.argvalue).size()) {
            double la = (Double)((ArrayList)lens.argvalue).get(i);
            if (la > (double)length) {
                ((ArrayList)lexs.argvalue).remove(i);
                ((ArrayList)lens.argvalue).remove(i);
                continue;
            }
            ++i;
        }
    }

    private void keepOnlyInside(RefObject<ArrayList<String>> lexs, RefObject<ArrayList<Double>> lens, int length) {
        ParameterCheck.mandatory("lexs", lexs);
        ParameterCheck.mandatory("lens", lens);
        int i = 0;
        while (i < ((ArrayList)lexs.argvalue).size()) {
            double la = (Double)((ArrayList)lens.argvalue).get(i);
            if (la >= (double)length) {
                ((ArrayList)lexs.argvalue).remove(i);
                ((ArrayList)lens.argvalue).remove(i);
                continue;
            }
            ++i;
        }
    }

    private void keepOnlyLongest(RefObject<ArrayList<String>> lexs, RefObject<ArrayList<Double>> lens) {
        int i;
        ParameterCheck.mandatory("lexs", lexs);
        ParameterCheck.mandatory("lens", lens);
        double maxlen = 0.0;
        for (i = 0; i < ((ArrayList)lexs.argvalue).size(); ++i) {
            double li = (Double)((ArrayList)lens.argvalue).get(i);
            if (!(li > maxlen)) continue;
            maxlen = li;
        }
        i = 0;
        while (i < ((ArrayList)lexs.argvalue).size()) {
            double la = (Double)((ArrayList)lens.argvalue).get(i);
            if (la < maxlen) {
                ((ArrayList)lexs.argvalue).remove(i);
                ((ArrayList)lens.argvalue).remove(i);
                continue;
            }
            ++i;
        }
    }

    private String cleanupAndAddQuotes(String feature) {
        ParameterCheck.mandatoryString("feature", feature);
        if (feature.equals("")) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        if (feature.charAt(0) != '\"' || feature.charAt(feature.length() - 1) != '\"') {
            sb.append('\"');
        }
        for (int i = 0; i < feature.length(); ++i) {
            if (feature.charAt(i) == '<' || feature.charAt(i) == '>') continue;
            sb.append(feature.charAt(i));
        }
        if (feature.charAt(0) != '\"' || feature.charAt(feature.length() - 1) != '\"') {
            sb.append('\"');
        }
        return sb.toString();
    }

    private String cleanupXmlTags(String line) {
        ParameterCheck.mandatoryString("line", line);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) != '<') {
                sb.append(line.charAt(i));
                continue;
            }
            ++i;
            while (line.charAt(i) != '>') {
                ++i;
            }
        }
        return sb.toString();
    }

    public final void buildXmlTaggedText(String currentLine, int beg, boolean filterOut, PrintWriter pw, int itu, ArrayList<Object> annotations, String[] xmlAnnotations, Language lan, boolean insideOnly) {
        ParameterCheck.mandatory("pw", pw);
        ParameterCheck.mandatoryCollection("annotations", annotations);
        ParameterCheck.mandatory("xmlAnnotations", xmlAnnotations);
        ParameterCheck.mandatory("lan", lan);
        int iChar = 0;
        while (iChar < currentLine.length()) {
            String token;
            int cpos;
            if (Character.isWhitespace(currentLine.charAt(iChar))) {
                if (!filterOut) {
                    pw.print(currentLine.charAt(iChar));
                }
                ++iChar;
                continue;
            }
            if (Language.isLetter(currentLine.charAt(cpos = iChar++))) {
                while (iChar < currentLine.length() && Language.isLetter(currentLine.charAt(iChar))) {
                    ++iChar;
                }
                token = currentLine.substring(cpos, iChar);
            } else if (this.XmlNodes != null && currentLine.charAt(cpos) == '<') {
                int level = 1;
                ++iChar;
                while (iChar < currentLine.length()) {
                    if (currentLine.charAt(iChar) == '>') {
                        if (--level == 0) {
                            break;
                        }
                    } else if (currentLine.charAt(iChar) == '<') {
                        ++level;
                    }
                    ++iChar;
                }
                if (iChar < currentLine.length()) {
                    ++iChar;
                    continue;
                }
                iChar = cpos + 1;
                token = currentLine.substring(cpos, cpos + 1);
            } else {
                ++iChar;
                token = currentLine.substring(cpos, cpos + 1);
            }
            ArrayList lexIds = null;
            ArrayList lens = null;
            ArrayList rlexs = null;
            ArrayList rlens = null;
            RefObject<Object> tempRef_lexids = new RefObject<Object>(lexIds);
            RefObject<Object> tempRef_lens = new RefObject<Object>(lens);
            int da = this.mft.getAllLexIdsAndContracted(itu, beg + cpos, tempRef_lexids, tempRef_lens);
            lexIds = (ArrayList)tempRef_lexids.argvalue;
            lens = (ArrayList)tempRef_lens.argvalue;
            if (da > 0) {
                ArrayList lexs = new ArrayList();
                for (int i = 0; i < da; ++i) {
                    int tkId = (Integer)lexIds.get(i);
                    String lex = (String)annotations.get(tkId);
                    if (lex == null) continue;
                    lexs.add(lex);
                }
                RefObject<ArrayList<String>> tempRef_lexs = new RefObject<ArrayList<String>>(lexs);
                RefObject<ArrayList<Double>> tempRef_lens2 = new RefObject<ArrayList<Double>>(lens);
                this.keepOnlyInternal(tempRef_lexs, tempRef_lens2, currentLine.length() - cpos);
                lexs = (ArrayList)tempRef_lexs.argvalue;
                lens = (ArrayList)tempRef_lens2.argvalue;
                RefObject<ArrayList<String>> tempRef_lexs2 = new RefObject<ArrayList<String>>(lexs);
                RefObject<ArrayList<Double>> tempRef_lens3 = new RefObject<ArrayList<Double>>(lens);
                if (insideOnly && cpos == 0) {
                    this.keepOnlyInside(tempRef_lexs2, tempRef_lens3, currentLine.length() - cpos);
                }
                lexs = (ArrayList)tempRef_lexs2.argvalue;
                lens = (ArrayList)tempRef_lens3.argvalue;
                RefObject<ArrayList<String>> tempRef_lexs3 = new RefObject<ArrayList<String>>(lexs);
                RefObject<ArrayList<Double>> tempRef_lens4 = new RefObject<ArrayList<Double>>(lens);
                this.keepOnlyLongest(tempRef_lexs3, tempRef_lens4);
                lexs = (ArrayList)tempRef_lexs3.argvalue;
                lens = (ArrayList)tempRef_lens4.argvalue;
                if (da > 0) {
                    Grammar g = new Grammar();
                    RefObject<ArrayList<String>> tempRef_rlexs = new RefObject<ArrayList<String>>(rlexs);
                    RefObject<ArrayList<Double>> tempRef_rlens = new RefObject<ArrayList<Double>>(rlens);
                    g.xmlFilterMatches(lexs, lens, xmlAnnotations, tempRef_rlexs, tempRef_rlens);
                    rlexs = (ArrayList)tempRef_rlexs.argvalue;
                    rlens = (ArrayList)tempRef_rlens.argvalue;
                }
            }
            if (rlexs != null && rlexs.size() > 0) {
                int len = 0;
                boolean thereIsATrans = false;
                for (int i = 0; i < rlexs.size(); ++i) {
                    String[] features;
                    RefObject<Object> tempRef_features;
                    String category;
                    RefObject<Object> tempRef_category;
                    String lemma;
                    RefObject<Object> tempRef_lemma;
                    String entry;
                    RefObject<Object> tempRef_entry;
                    String lex = (String)rlexs.get(i);
                    boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), null, tempRef_category = new RefObject<Object>((category = null)), null, tempRef_features = new RefObject<Object>((features = null)));
                    entry = (String)tempRef_entry.argvalue;
                    lemma = (String)tempRef_lemma.argvalue;
                    category = (String)tempRef_category.argvalue;
                    features = (String[])tempRef_features.argvalue;
                    if (tempVar || !lemma.equals("SYNTAX") || !category.equals("TRANS")) continue;
                    thereIsATrans = true;
                    if (features != null) {
                        String propvalue;
                        String propname;
                        String feat;
                        int ifeat;
                        String txtzone = null;
                        String propzone = null;
                        for (ifeat = 0; ifeat < features.length; ++ifeat) {
                            feat = features[ifeat];
                            propname = null;
                            propvalue = null;
                            RefObject<Object> tempRef_propname = new RefObject<Object>(propname);
                            RefObject<Object> tempRef_propvalue = new RefObject<Object>(propvalue);
                            Dic.getPropertyNameValue(feat, tempRef_propname, tempRef_propvalue);
                            propname = (String)tempRef_propname.argvalue;
                            propvalue = (String)tempRef_propvalue.argvalue;
                            for (int j = 0; j < xmlAnnotations.length; ++j) {
                                if (!xmlAnnotations[j].equals("<TRANS+" + propname + ">")) continue;
                                propzone = propname;
                                txtzone = propvalue;
                            }
                        }
                        if (propzone != null) {
                            pw.print("<" + propzone);
                            for (ifeat = 0; ifeat < features.length; ++ifeat) {
                                feat = features[ifeat];
                                propname = null;
                                propvalue = null;
                                RefObject<String> tempRef_propname2 = new RefObject<String>(propname);
                                RefObject<String> tempRef_propvalue2 = new RefObject<String>(propvalue);
                                Dic.getPropertyNameValue(feat, tempRef_propname2, tempRef_propvalue2);
                                propname = (String)tempRef_propname2.argvalue;
                                propvalue = (String)tempRef_propvalue2.argvalue;
                                if (propzone.equals(propname)) continue;
                                pw.print(" \"" + propname + "\"");
                            }
                            pw.print(">");
                            pw.print(txtzone + "</" + propzone + ">");
                        } else {
                            thereIsATrans = false;
                            continue;
                        }
                    }
                    double helpDouble = (Double)rlens.get(i);
                    len = (int)helpDouble;
                    iChar = cpos + len;
                    break;
                }
                if (thereIsATrans) continue;
                if (rlexs == null || rlexs.isEmpty()) {
                    if (filterOut) continue;
                    pw.print(token);
                    continue;
                }
                boolean thereisunamb = false;
                for (int i = 0; i < rlexs.size(); ++i) {
                    String propvalue;
                    String propname;
                    String[] features;
                    RefObject<Object> tempRef_features2;
                    String category;
                    RefObject<Object> tempRef_category2;
                    String lemma;
                    RefObject<Object> tempRef_lemma2;
                    String entry;
                    RefObject<Object> tempRef_entry2;
                    String lex = (String)rlexs.get(i);
                    boolean tempVar2 = !Dic.parseDELAF(lex, tempRef_entry2 = new RefObject<Object>((entry = null)), tempRef_lemma2 = new RefObject<Object>((lemma = null)), null, tempRef_category2 = new RefObject<Object>((category = null)), null, tempRef_features2 = new RefObject<Object>((features = null)));
                    entry = (String)tempRef_entry2.argvalue;
                    lemma = (String)tempRef_lemma2.argvalue;
                    category = (String)tempRef_category2.argvalue;
                    features = (String[])tempRef_features2.argvalue;
                    if (tempVar2 || category.equals("TRANS")) continue;
                    if (lemma.equals("SYNTAX")) {
                        pw.print("<" + category);
                        if (features != null) {
                            for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                                String feat = features[ifeat];
                                propname = null;
                                propvalue = null;
                                RefObject<Object> tempRef_propname3 = new RefObject<Object>(propname);
                                RefObject<Object> tempRef_propvalue3 = new RefObject<Object>(propvalue);
                                Dic.getPropertyNameValue(feat, tempRef_propname3, tempRef_propvalue3);
                                propname = (String)tempRef_propname3.argvalue;
                                propvalue = (String)tempRef_propvalue3.argvalue;
                                if (propvalue.equals("UNAMB")) {
                                    thereisunamb = true;
                                    continue;
                                }
                                if (propname.equals(propvalue)) {
                                    pw.print(" TYPE=" + this.cleanupAndAddQuotes(propvalue));
                                    continue;
                                }
                                pw.print(" " + propname + "=" + this.cleanupAndAddQuotes(propvalue));
                            }
                        }
                        pw.print(">");
                        continue;
                    }
                    pw.print("<LU LEMMA=\"" + lemma + "\" CAT=\"" + category + "\"");
                    if (features != null) {
                        for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                            String feat = features[ifeat];
                            propname = null;
                            propvalue = null;
                            RefObject<Object> tempRef_propname4 = new RefObject<Object>(propname);
                            RefObject<Object> tempRef_propvalue4 = new RefObject<Object>(propvalue);
                            Dic.getPropertyNameValue(feat, tempRef_propname4, tempRef_propvalue4);
                            propname = (String)tempRef_propname4.argvalue;
                            propvalue = (String)tempRef_propvalue4.argvalue;
                            if (propvalue.equals("UNAMB")) {
                                thereisunamb = true;
                                continue;
                            }
                            if (feat.equals(propname)) {
                                pw.print(" TYPE=" + this.cleanupAndAddQuotes(propvalue));
                                continue;
                            }
                            pw.print(" " + propname + "=" + this.cleanupAndAddQuotes(propvalue));
                        }
                    }
                    pw.print(">");
                }
                double helpDouble = (Double)rlens.get(0);
                len = (int)helpDouble;
                if (len == 0) {
                    len = token.length();
                }
                String recurrentline = currentLine.substring(cpos, cpos + len);
                if (len > token.length()) {
                    if (thereisunamb) {
                        pw.print(this.cleanupXmlTags(recurrentline));
                    } else {
                        this.buildXmlTaggedText(recurrentline, beg + cpos, filterOut, pw, itu, annotations, xmlAnnotations, lan, true);
                    }
                } else {
                    pw.print(this.cleanupXmlTags(recurrentline));
                }
                iChar = cpos + len;
                for (int i = rlexs.size() - 1; i >= 0; --i) {
                    String[] features;
                    RefObject<Object> tempRef_features3;
                    String category;
                    RefObject<Object> tempRef_category3;
                    String lemma;
                    RefObject<Object> tempRef_lemma3;
                    String entry;
                    RefObject<Object> tempRef_entry3;
                    String lex = (String)rlexs.get(i);
                    boolean tempVar3 = !Dic.parseDELAF(lex, tempRef_entry3 = new RefObject<Object>((entry = null)), tempRef_lemma3 = new RefObject<Object>((lemma = null)), null, tempRef_category3 = new RefObject<Object>((category = null)), null, tempRef_features3 = new RefObject<Object>((features = null)));
                    entry = (String)tempRef_entry3.argvalue;
                    lemma = (String)tempRef_lemma3.argvalue;
                    category = (String)tempRef_category3.argvalue;
                    features = (String[])tempRef_features3.argvalue;
                    if (tempVar3 || category.equals("TRANS")) continue;
                    if (lemma.equals("SYNTAX")) {
                        pw.print("</" + category + ">");
                        continue;
                    }
                    pw.print("</LU>");
                }
                continue;
            }
            if (filterOut) continue;
            pw.print(token);
        }
    }

    private static void computehLexemes(Ntext text) {
        ParameterCheck.mandatory("text", text);
        text.hLexemes = new HashMap();
        text.hPhrases = new HashMap();
        text.hUnknowns = new HashMap();
        if (text.annotations.size() > 0) {
            for (int i = 0; i < text.annotations.size(); ++i) {
                String lex = (String)text.annotations.get(i);
                if (lex == null) continue;
                String entry = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                String lemma = null;
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                String info = null;
                RefObject<Object> tempRef_info = new RefObject<Object>(info);
                boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry, tempRef_lemma, tempRef_info, null, null, null);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                info = (String)tempRef_info.argvalue;
                if (tempVar) {
                    Dic.writeLog("Invalid annotation: \"" + lex + "\"");
                }
                if (info.equals("UNKNOWN")) {
                    if (text.hUnknowns.containsKey(lex)) continue;
                    text.hUnknowns.put(lex, i);
                    continue;
                }
                if (lemma.equals("SYNTAX")) {
                    if (text.hPhrases.containsKey(lex)) continue;
                    text.hPhrases.put(lex, i);
                    continue;
                }
                if (text.hLexemes.containsKey(lex)) continue;
                text.hLexemes.put(lex, i);
            }
        }
    }

    public static Ntext load(String fullNamePath, String languageName, RefObject<String> errMessage) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("fullNamePath", fullNamePath);
        ParameterCheck.mandatoryString("languageName", languageName);
        ParameterCheck.mandatory("errMessage", errMessage);
        errMessage.argvalue = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        Ntext text = null;
        try {
            fileInputStream = new FileInputStream(fullNamePath);
            objectInputStream = new ObjectInputStream(fileInputStream);
            text = (Ntext)objectInputStream.readObject();
        }
        catch (RuntimeException ex) {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            errMessage.argvalue = "Cannot load text " + fullNamePath + ": " + ex.getMessage();
            Dic.writeLog((String)errMessage.argvalue);
            return null;
        }
        if (objectInputStream != null) {
            objectInputStream.close();
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        text.Lan = new Language(text.LanguageName);
        if (text.Lan == null) {
            return null;
        }
        double multiplier = 1.0;
        if (text.annotations != null && text.annotations.size() > 0) {
            if (text.annotations.get(0) != null && text.annotations.get(0).getClass() == HashMap.class) {
                text.hTokens = (HashMap)text.annotations.get(0);
                text.annotations.remove(0);
            } else {
                String keyword;
                do {
                    if ((keyword = (String)text.annotations.get(0)).equals("$tokens$")) {
                        text.hTokens = (HashMap)text.annotations.get(1);
                        text.annotations.remove(0);
                        text.annotations.remove(0);
                        continue;
                    }
                    if (keyword.equals("$colors$")) {
                        text.annotations.remove(0);
                        text.annotations.remove(0);
                        continue;
                    }
                    if (keyword.equals("$multiplier$")) {
                        multiplier = text.annotations.get(1) == null ? 100.0 : (Double)text.annotations.get(1);
                        text.annotations.remove(0);
                        text.annotations.remove(0);
                        continue;
                    }
                    if (!keyword.equals("$resources$")) continue;
                    text.listOfResources = (ArrayList)text.annotations.get(1);
                    text.annotations.remove(0);
                    text.annotations.remove(0);
                } while (text.annotations.size() > 0 && (keyword.equals("$tokens$") || keyword.equals("$colors$") || keyword.equals("$multiplier$") || keyword.equals("$resources$")));
            }
        }
        if (text.mft != null) {
            text.mft.afterLoading(multiplier);
        }
        if (text.annotations != null) {
            Ntext.computehLexemes(text);
        }
        return text;
    }

    public final void save(String fullNamePath) throws IOException {
        File file;
        ParameterCheck.mandatoryString("fullNamePath", fullNamePath);
        int nbOfHacks = 0;
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        if (this.hTokens != null) {
            this.annotations.add(0, "$tokens$");
            this.annotations.add(1, this.hTokens);
            ++nbOfHacks;
        }
        if (this.listOfResources != null) {
            this.annotations.add(0, "$resources$");
            this.annotations.add(1, this.listOfResources);
            ++nbOfHacks;
        }
        if (this.mft != null) {
            this.mft.beforeSaving();
            this.annotations.add(0, "$multiplier$");
            this.annotations.add(1, null);
            ++nbOfHacks;
        }
        if (!(file = new File(fullNamePath)).exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
        fileOutputStream.close();
        if (nbOfHacks > 0) {
            for (int i = 0; i < nbOfHacks; ++i) {
                this.annotations.remove(0);
                this.annotations.remove(0);
            }
        }
    }

    public final boolean updateAnnotationsForText() {
        if (this.mft == null) {
            return false;
        }
        boolean[] exist = new boolean[this.annotations.size()];
        for (int i = 0; i < exist.length; ++i) {
            exist[i] = false;
        }
        for (int tuNb = 1; tuNb <= this.mft.tuAddresses.length - 1; ++tuNb) {
            ArrayList<TransitionObject> transitions = this.mft.aTransitions.get(tuNb);
            for (int it = 0; it < transitions.size(); ++it) {
                ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
                for (int io = 0; io < outgoings.size(); ++io) {
                    int tokenId = outgoings.get(io).getTokenId();
                    if (tokenId >= exist.length) {
                        return false;
                    }
                    exist[tokenId] = true;
                }
            }
        }
        for (int ia = 0; ia < this.annotations.size(); ++ia) {
            String label;
            if (exist[ia] || (label = (String)this.annotations.get(ia)) == null) continue;
            String entry = null;
            String info = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            boolean tempVar = Dic.parseDELAS(label, tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            if (!tempVar) continue;
            this.annotations.set(ia, null);
        }
        return true;
    }

    public Language getLanguage() {
        return this.Lan;
    }

    public String getDelimPattern() {
        return this.DelimPattern;
    }

    public ArrayList<Object> getAnnotations() {
        return this.annotations;
    }
}

